var mouse_event_timer;

/* STAD - "Show Tip After Delay */
function STAD( event, rank, samples, size ) {
	var xpos = event.clientX;
	var ypos = event.clientY;
	clearTimeout( mouse_event_timer );
	mouse_event_timer = setTimeout( function() { show_tip( xpos, ypos, rank, samples, size ); }, 150 );
}

/* HTAD - "Hide Tip After Delay */
function HTAD( ) {
	clearTimeout( mouse_event_timer );
	mouse_event_timer = setTimeout( function() { hide_tip(); }, 150 );
}

function show_tip( xpos, ypos, rank, samples, size ) {

	var tooltip = document.getElementById('tip');
	tooltip.style.left = (xpos+3) + 'px';
	tooltip.style.top = (ypos+3) + 'px';
	
	if( size )
	{
			tooltip.innerHTML = "Rank: " + rank + "<br>Number of Samples: " + samples + "<br>Size: " + size + "<BR>";
	}
	else
		{
		tooltip.innerHTML = "Rank: " + rank + "<br>Number of Samples: " + samples + "<br>";
	}
	
	tooltip.style.visibility='visible';
}

function hide_tip( ) {
	var tooltip = document.getElementById('tip');
	tooltip.style.visibility='hidden';
}
